//=============================================================================
// ElementAmplify.js
// ----------------------------------------------------------------------------
// (C)2022 kuroame koubou
// This software is released under the MIT License.
// http://opensource.org/licenses/mit-license.php
// ----------------------------------------------------------------------------
// Version
// 0.9.0 2022/06/24 初版
// ----------------------------------------------------------------------------
// [Blog]   : http://kuroamekoubou.blog.fc2.com
// [Twitter]: https://twitter.com/kuroVelter9623
//=============================================================================

/*:
 * @plugindesc 属性出力機構プラグイン
 * @target MZ
 * @author くろあめ
 *
 * @help
 * 指定のメタタグをメモ欄に記載することで
 * その要素を持つアクター/エネミーが、指定した属性で攻撃する際に
 * 威力を増幅させる機能を搭載するプラグインです。
 * 
 * 
 * 
 * アクター、エネミー、職業、装備、ステートのメモ欄に
 * <ElmMagniBst:x,yy>と記載することで 
 * その要素を持つアクター/エネミーが、ID:x番の属性で攻撃する際に
 * その威力をyy%増幅させます。
 * 
 * 【設定例】
 * <ElmMagniBst:2,30> とメモ欄に記載された武器を装備するアクターの 
 * ID:2番の属性(デフォルトでは炎)の攻撃は、30%威力が上昇します。
 * 
 * <ElmMagniBst:1,50> とメモ欄に記載されたステートを付与されたアクター/エネミーの
 * ID:1番の属性(デフォルトでは物理) の攻撃は、45%威力が上昇します。
 * 
 * 通常攻撃などの複合属性攻撃の場合は
 * 第一属性がこの機能の対象になります。
 * 
 * 増幅率には、マイナス指定が可能です
 * ただし、増幅値が100%以下になった場合の下限値は1%となります。
 * 
 * 
 * 
 * また、指定のメタタグをスキルとアクター/エネミーの両方に記載することで
 * 特定のタグを記載したスキルの威力を増幅させる機能も搭載しています。
 * 
 * アクター、エネミー、職業、装備、ステートのメモ欄に
 * <TypeMagniBst:x,yy>と記載することで 
 * その要素を持つアクター/エネミーが、<TypeMagniBst:x>と記述されたスキルで攻撃する際に
 * その威力をyy%増幅させます。
 * 
 * 
 * 【設定例】
 * スキルID1番（通常攻撃）のメモ欄に、<TypeMagniBst:1>を記述し 
 * <TypeMagniBst:1,30> とメモ欄に記載された職業に就いているアクターの通常攻撃は
 * 30%威力が上昇します。
 *
 * 全ての剣攻撃スキルのメモ欄に、<TypeMagniBst:2>を記述し 
 * <TypeMagniBst:2,15> とメモ欄に記載された武器を装備するアクターの 
 * 全ての剣攻撃スキルは、15%威力が上昇します。
 * 
 * 増幅率には、マイナス指定が可能です
 * ただし、増幅値が100%以下になった場合の下限値は1%となります。
 * 
 * 
 * 
 * <ElmMagniBst> <TypeMagniBst> タグは
 * メモ帳ひとつにつき1つの記載しか有効になりません
 * 複数の装備やステートなどに記載された分は、全て加味されます。
 *
 *
 *
 * 利用形態（商用、18禁利用等）について制限はありません
 * 作者への使用報告や、ReadMeなどへ作者・サイト名の記載も任意となります。
 *
 * ただし、作者はこれらのプラグインについて
 * 基本的に一切のサポートを行いません
 * 何か問題が起きた時、ご自身で解決できる方のみご利用ください。
 */

(function() {

/* アクターの属性倍率増幅値取得 */
Game_Actor.prototype.getElmMagniBst = function(elmId) {

    var lastMagni = 100;
    var getMeta;
    
    if (elmId == null) {
        return lastMagni;
    }
    
    const states = this.states();
    for (let i = 0; i < states.length; i++) {
        if (states[i] && states[i].meta && states[i].meta.ElmMagniBst){
            getMeta = states[i].meta.ElmMagniBst.split(',');
            if(getMeta[0] == elmId) lastMagni += Number(getMeta[1]);
        }
    }
    if (this.actor() && this.actor().meta && this.actor().meta.ElmMagniBst) {
        getMeta = this.actor().meta.ElmMagniBst.split(',');
        if(getMeta[0] == elmId) lastMagni += Number(getMeta[1]);
    }
    if (this.currentClass() && this.currentClass().meta && this.currentClass().meta.ElmMagniBst)  {
        getMeta = this.currentClass().meta.ElmMagniBst.split(',');
        if(getMeta[0] == elmId) lastMagni += Number(getMeta[1]);
    }
    
    const equips = this.equips();
    for (let i = 0; i < equips.length; i++) {      
        if (equips[i] && equips[i].meta && equips[i].meta.ElmMagniBst){
            getMeta = equips[i].meta.ElmMagniBst.split(',');
            if(getMeta[0] == elmId) lastMagni += Number(getMeta[1]);
        }
    }
    
    return lastMagni;
};

/* アクターの表示用属性倍率増幅値取得 */
Game_Actor.prototype.dispElmMagni = function(elmId) {
    return this.getElmMagniBst(elmId);
};

/* エネミーの属性倍率増幅値取得 */
Game_Enemy.prototype.getElmMagniBst = function(elmId) {
    
    var lastMagni = 100;
    
    if (elmId == null) {
        return lastMagni;
    }
    
    var states = this.states();
    for (let i = 0; i < states.length; i++) {
        if (states[i] && states[i].meta && states[i].meta.ElmMagniBst){
            getMeta = states[i].meta.ElmMagniBst.split(',');
            if(getMeta[0] == elmId) lastMagni += Number(getMeta[1]);
        }
    }
    if (this.enemy() && this.enemy().meta && this.enemy().meta.ElmMagniBst) {
        getMeta = this.enemy().meta.ElmMagniBst.split(',');
        if(getMeta[0] == elmId) lastMagni += Number(getMeta[1]);
    }
    
    return lastMagni;
};

/* アクターの指定タグ倍率増幅値取得 */
Game_Actor.prototype.getTypeMagniBst = function(typeId) {

    var lastMagni = 100;
    var getMeta;
    
    if (typeId == null) {
        return lastMagni;
    }
    
    const states = this.states();
    for (let i = 0; i < states.length; i++) {
        if (states[i] && states[i].meta && states[i].meta.TypeMagniBst){
            getMeta = states[i].meta.TypeMagniBst.split(',');
            if(getMeta[0] == typeId) lastMagni += Number(getMeta[1]);
        }
    }
    if (this.actor() && this.actor().meta && this.actor().meta.TypeMagniBst) {
        getMeta = this.actor().meta.TypeMagniBst.split(',');
        if(getMeta[0] == typeId) lastMagni += Number(getMeta[1]);
    }
    if (this.currentClass() && this.currentClass().meta && this.currentClass().meta.TypeMagniBst)  {
        getMeta = this.currentClass().meta.TypeMagniBst.split(',');
        if(getMeta[0] == typeId) lastMagni += Number(getMeta[1]);
    }
    
    const equips = this.equips();
    for (let i = 0; i < equips.length; i++) {      
        if (equips[i] && equips[i].meta && equips[i].meta.TypeMagniBst){
            getMeta = equips[i].meta.TypeMagniBst.split(',');
            if(getMeta[0] == typeId) lastMagni += Number(getMeta[1]);
        }
    }
    
    return lastMagni;
};

/* エネミーの指定タグ倍率増幅値取得 */
Game_Enemy.prototype.getTypeMagniBst = function(typeId) {
    
    var lastMagni = 100;
    
    if (typeId == null) {
        return lastMagni;
    }
    
    var states = this.states();
    for (let i = 0; i < states.length; i++) {
        if (states[i] && states[i].meta && states[i].meta.TypeMagniBst){
            getMeta = states[i].meta.TypeMagniBst.split(',');
            if(getMeta[0] == typeId) lastMagni += Number(getMeta[1]);
        }
    }
    if (this.enemy() && this.enemy().meta && this.enemy().meta.TypeMagniBst) {
        getMeta = this.enemy().meta.TypeMagniBst.split(',');
        if(getMeta[0] == typeId) lastMagni += Number(getMeta[1]);
    }
    
    return lastMagni;
};


/* バトラーの属性出力計算 */
// NUUN_MultiElement 対応型
Game_Action.prototype.calcElmMagni = function(value) {
    
    var item = this.item();
    
    if (item.damage.elementId < 0) {
        var atkElms = this.getAttackElements();
    } else {
        var atkElms = this.getItemElements();
    }
    
    var lastMagni = 100;
    
    //var teststr = "";
    //console.log(teststr.concat(this.subject().name()," ",item.name," 攻撃全属性"));
    //console.log(atkElms.join(","));
    
    for (let elmId of atkElms) {
        //console.log(elmId);
        lastMagni += this.subject().getElmMagniBst(elmId) - 100;
    }
    
    //var teststr = "";
    //console.log(teststr.concat(this.subject().name()," ",item.name," 最終倍率"));
    //console.log(lastMagni);
    
    if (lastMagni < 1) lastMagni = 1;
    return Math.round(value * lastMagni / 100);
};

/* バトラーの属性出力計算 */
/* 汎用型
Game_Action.prototype.calcElmMagni = function(value) {
    var item = this.item();
    if (item.damage.elementId < 0) {
        atkElms = this.subject().attackElements();
        elmId = atkElms[0];
    } else {
        elmId = item.damage.elementId;
    }
    lastMagni = this.subject().getElmMagniBst(elmId);
    if (lastMagni < 1) lastMagni = 1;
    return Math.round(value * lastMagni / 100);
};
*/ 


/* バトラーの指定タグ倍率出力計算 */
Game_Action.prototype.calcTypeMagni = function(value) {
    var item = this.item();
    if (item && item.meta && item.meta.TypeMagniBst) {
        var typeId = item.meta.TypeMagniBst;
        var lastMagni = this.subject().getTypeMagniBst(typeId);
        if (lastMagni < 1) lastMagni = 1;
        return Math.round(value * lastMagni / 100);
    }
    return value;
};

/* ダメージ計算関数の末尾で属性出力を加味 */
const _Game_Action_makeDamageValue_ElmAply = Game_Action.prototype.makeDamageValue;
Game_Action.prototype.makeDamageValue = function(target, critical){
    var value = _Game_Action_makeDamageValue_ElmAply.apply(this, arguments);
    value = this.calcElmMagni(value); // 属性出力計算
    value = this.calcTypeMagni(value); // 指定タグ出力計算
    return value;
};


})();
